/*
 * Decompiled with CFR 0.152.
 */
package dec;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogTrace {
    private static String _newLine = System.getProperty("line.separator");
    private static String _logFile = null;
    private static String _traceFile = null;
    private static int _minTraceLevel = 0;
    private static boolean _flush = true;
    private static BufferedWriter _logStream = null;
    private static BufferedWriter _traceStream = null;
    private static SimpleDateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static StringBuffer _logBuffer = null;
    private static StringBuffer _traceBuffer = null;

    private LogTrace() {
    }

    public static void init(String logFile, String traceFile, int id, int minTraceLevel, boolean flush) {
        SimpleDateFormat dateFormatOnlyDate = new SimpleDateFormat("yyyy-MM-dd");
        dateFormatOnlyDate.setLenient(false);
        Date sd = new Date();
        LogTrace.close();
        if (logFile != null && !logFile.equals("")) {
            _logFile = logFile.replaceAll("%d", dateFormatOnlyDate.format(sd)).replaceAll("%n", Integer.toString(id));
        }
        if (traceFile != null && !traceFile.equals("")) {
            _traceFile = traceFile.replaceAll("%d", dateFormatOnlyDate.format(sd)).replaceAll("%n", Integer.toString(id));
        }
        _minTraceLevel = Math.max(0, minTraceLevel);
        _flush = flush;
        _dateFormat.setLenient(false);
    }

    public static void close() {
        try {
            if (_logStream != null) {
                _logStream.close();
                _logStream = null;
            }
            if (_traceStream != null) {
                _traceStream.close();
                _traceStream = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLogBuffer(StringBuffer buffer) {
        _logBuffer = buffer;
    }

    public static void setTraceBuffer(StringBuffer buffer) {
        _logBuffer = buffer;
    }

    private static void writeLog(String text) throws Throwable {
        _logStream.write(text);
        if (_logBuffer != null) {
            _logBuffer.append(text);
        }
    }

    private static void writeTrace(String text) throws Throwable {
        _traceStream.write(text);
        if (_traceBuffer != null) {
            _traceBuffer.append(text);
        }
    }

    public static String log(String text, int mode) {
        if (_logFile == null) {
            return null;
        }
        try {
            if (_logStream == null) {
                _logStream = new BufferedWriter(new FileWriter(_logFile, true));
                LogTrace.writeLog(_newLine);
            }
            LogTrace.writeLog(_newLine);
            if (mode >= 0) {
                switch (mode) {
                    case 0: {
                        LogTrace.writeLog(_dateFormat.format(new Date()) + " ");
                        break;
                    }
                    case 1: {
                        LogTrace.writeLog("#   ");
                        break;
                    }
                    case 2: {
                        LogTrace.writeLog("?   ");
                        break;
                    }
                    default: {
                        LogTrace.writeLog("    ");
                    }
                }
            }
            LogTrace.writeLog(text);
            if (_flush) {
                _logStream.flush();
            }
        }
        catch (Throwable ex) {
            return ex.toString();
        }
        return null;
    }

    public static String trace(String text, int traceLevel, int mode) {
        if (_traceFile == null || traceLevel < _minTraceLevel) {
            return null;
        }
        try {
            if (_traceStream == null) {
                _traceStream = new BufferedWriter(new FileWriter(_traceFile, true));
            }
            LogTrace.writeTrace(_newLine);
            if (mode >= 0) {
                switch (mode) {
                    case 0: {
                        LogTrace.writeTrace(_dateFormat.format(new Date()) + " ");
                        break;
                    }
                    default: {
                        LogTrace.writeTrace("    ");
                    }
                }
            }
            LogTrace.writeTrace(text);
            if (_flush) {
                _traceStream.flush();
            }
        }
        catch (Throwable ex) {
            return ex.toString();
        }
        return null;
    }

    public static void flushLog() {
        if (!_flush) {
            try {
                _logStream.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void flushTrace() {
        if (!_flush) {
            try {
                _traceStream.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void logError(int mode, Throwable msg) {
        Throwable ex = msg;
        StackTraceElement[] stack = ex.getStackTrace();
        LogTrace.log(ex.toString(), mode);
        for (StackTraceElement el : stack) {
            LogTrace.log(el.toString(), 3);
        }
    }

    public static void traceError(int traceLevel, int mode, Throwable msg) {
        Throwable ex = msg;
        StackTraceElement[] stack = ex.getStackTrace();
        LogTrace.trace(ex.toString(), traceLevel, mode);
        for (StackTraceElement el : stack) {
            LogTrace.trace(el.toString(), traceLevel, 3);
        }
    }
}

