/*
 * Decompiled with CFR 0.152.
 */
package dec;

import dec.DECValidation;
import dec.Info;
import dec.LogTrace;
import dec.Options;
import dec.Validation;
import java.io.File;
import java.sql.Connection;
import java.util.Arrays;

public class ValidatorRoot
implements Validation {
    private String DECLARATION_name = null;
    private String[] _dateVersionTable = null;
    private int[] _an;
    private int[] _luna;
    private String[] _version;
    private int[] _idValidator;
    private int[] _idParameters;
    private int[] _indexOfParam;
    private String[] _schemaNamespace;
    private Info _info = null;
    private DECValidation[] _vld;
    private Object[] _prm;
    private Connection _con = null;
    static String _nl = System.getProperty("line.separator");
    protected Options[] _options = null;
    private long _option = 0L;

    protected ValidatorRoot() {
    }

    protected void initialize(String decName, String[] dateVersionTable) {
        int i;
        this.DECLARATION_name = decName;
        this._dateVersionTable = dateVersionTable;
        int len = this._dateVersionTable.length;
        this._vld = new DECValidation[len];
        this._prm = new Object[len];
        for (int i2 = 0; i2 < len; ++i2) {
            this._vld[i2] = null;
            this._prm[i2] = null;
        }
        Arrays.sort(this._dateVersionTable);
        len = this._dateVersionTable.length;
        this._an = new int[len];
        this._luna = new int[len];
        this._version = new String[len];
        this._idValidator = new int[len];
        this._idParameters = new int[len];
        this._indexOfParam = new int[len];
        this._schemaNamespace = new String[len];
        for (i = 0; i < len; ++i) {
            String[] dateStr;
            this._an[i] = 0;
            this._luna[i] = 0;
            this._version[i] = null;
            this._idValidator[i] = 0;
            this._idParameters[i] = 0;
            this._indexOfParam[i] = 0;
            String entry = this._dateVersionTable[i];
            String[] str = entry.split(" ");
            this._schemaNamespace[i] = null;
            if (str.length != 5 || (dateStr = str[0].split("-")).length != 2) continue;
            try {
                this._an[i] = Integer.parseInt(dateStr[0]);
                this._luna[i] = Integer.parseInt(dateStr[1]);
                this._version[i] = str[1];
                this._idValidator[i] = Integer.parseInt(str[2]);
                this._idParameters[i] = Integer.parseInt(str[3]);
                continue;
            }
            catch (Throwable ex) {
                this._an[i] = 0;
                this._luna[i] = 0;
                this._version[i] = null;
                this._idValidator[i] = 0;
                this._idParameters[i] = 0;
            }
        }
        for (i = 0; i < len; ++i) {
            for (int j = i - 1; j >= 0; --j) {
                if (this._idParameters[j] != this._idParameters[i]) continue;
                int n = i;
                this._indexOfParam[n] = this._indexOfParam[n] + 1;
            }
        }
    }

    public int setDbConnection(Connection con) {
        if (this._con != null) {
            return 1;
        }
        this._con = con;
        if (con == null) {
            return -1;
        }
        return 0;
    }

    public int parseDocumentIntern(int crt, String xmlFile, String errFile) {
        int ret = 0;
        try {
            Object prm;
            String clsName;
            DECValidation vld;
            if (this._info == null) {
                this._info = new Info();
            }
            if ((vld = this._vld[this._idValidator[crt]]) == null) {
                clsName = this.DECLARATION_name + "validator.v" + Integer.toString(this._idValidator[crt]) + ".ValidatorImpl";
                vld = (DECValidation)Class.forName(clsName, true, this.getClass().getClassLoader()).newInstance();
                if (this._con != null) {
                    vld.setDbConnection(this._con);
                }
                vld.setOption(this._option);
                this._vld[this._idValidator[crt]] = vld;
                this._schemaNamespace[this._idValidator[crt]] = vld.getSchemaNamespace();
            }
            if ((prm = this._prm[this._idParameters[crt]]) == null) {
                clsName = this.DECLARATION_name + "validator.parameters.Parameters_v" + Integer.toString(this._idParameters[crt]);
                this._prm[this._idParameters[crt]] = prm = Class.forName(clsName, true, this.getClass().getClassLoader()).newInstance();
            }
            if (this._con != null) {
                vld.enableDbOperation();
            }
            this._info._indexOfPair = this._indexOfParam[crt];
            ret = vld.parseDocument(xmlFile, errFile, this._info, prm);
            this._info._version = this._version[crt];
        }
        catch (ClassNotFoundException ex) {
            this.logError(-6, ex);
            return -6;
        }
        catch (InstantiationException ex) {
            this.logError(-7, ex);
            return -7;
        }
        catch (IllegalAccessException ex) {
            this.logError(-7, ex);
            return -7;
        }
        catch (Throwable ex) {
            this.logError(-5, ex);
            return -5;
        }
        return ret;
    }

    public int parseDocument(String xmlFile, String errFile, int an, int luna, String tipPerioda) {
        int ret = 0;
        int len = this._dateVersionTable.length;
        int ret4 = 0;
        try {
            int crt;
            if (an < this._an[0] || an == this._an[0] && luna < this._luna[0] || an >= 2100 || luna < 1 || luna > 12) {
                this.logError(-4, "perioada de raportare eronata");
                crt = 1;
                ret4 = -4;
            } else {
                for (crt = 1; crt < len && an >= this._an[crt] && (an != this._an[crt] || luna >= this._luna[crt]); ++crt) {
                }
            }
            ret = this.parseDocumentIntern(--crt, xmlFile, errFile);
        }
        catch (Throwable ex) {
            this.logError(-5, ex);
            return -5;
        }
        if (ret4 != 0) {
            return -4;
        }
        return ret;
    }

    public int parseDocument(String xmlFile, String errFile, String version) {
        int ret = 0;
        int len = this._dateVersionTable.length;
        try {
            int crt;
            for (crt = 0; crt < len && !version.equals(this._version[crt]); ++crt) {
            }
            if (crt >= len) {
                return -4;
            }
            ret = this.parseDocumentIntern(crt, xmlFile, errFile);
        }
        catch (Throwable ex) {
            this.logError(-5, ex);
            return -5;
        }
        return ret;
    }

    public int parseDocument(String xmlFile, String errFile) {
        int ret = 0;
        int crt = 0;
        String clsName = null;
        String schema = null;
        try {
            if (this._info == null) {
                this._info = new Info();
            }
            schema = null;
            for (crt = this._vld.length - 1; crt >= 0; --crt) {
                Object prm;
                DECValidation vld = this._vld[this._idValidator[crt]];
                if (vld == null) {
                    clsName = this.DECLARATION_name + "validator.v" + Integer.toString(this._idValidator[crt]) + ".ValidatorImpl";
                    vld = (DECValidation)Class.forName(clsName, true, this.getClass().getClassLoader()).newInstance();
                    if (this._con != null) {
                        vld.setDbConnection(this._con);
                    }
                    vld.setOption(this._option);
                    this._vld[this._idValidator[crt]] = vld;
                    this._schemaNamespace[this._idValidator[crt]] = vld.getSchemaNamespace();
                }
                if ((prm = this._prm[this._idParameters[crt]]) == null) {
                    clsName = this.DECLARATION_name + "validator.parameters.Parameters_v" + Integer.toString(this._idParameters[crt]);
                    this._prm[this._idParameters[crt]] = prm = Class.forName(clsName, true, this.getClass().getClassLoader()).newInstance();
                }
                if (schema != null && !schema.equals(this._schemaNamespace[this._idValidator[crt]])) continue;
                vld.disableDbOperation();
                this._info._indexOfPair = this._indexOfParam[crt];
                ret = vld.parseDocument(xmlFile, errFile, this._info, prm, 1);
                if (this._con != null) {
                    vld.enableDbOperation();
                }
                if (ret >= 0) break;
                schema = this._info._schemaNamespace;
            }
            if (ret >= 0) {
                new File(errFile).delete();
                return this.parseDocument(xmlFile, errFile, Integer.parseInt(this._info._an), Integer.parseInt(this._info._luna), this._info._tipPerioada);
            }
            return ret;
        }
        catch (Throwable ex) {
            this.logError(-5, ex);
            return -5;
        }
    }

    public Info getInfo() {
        return this._info;
    }

    public String getLastVersion() {
        return this._version[this._version.length - 1];
    }

    private static String padPath(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            return path + File.separator;
        }
        return path;
    }

    public Options[] getOptions() {
        return this._options;
    }

    public void useOptions(long option) {
        this._option = option;
        for (int i = 0; i < this._vld.length; ++i) {
            if (this._vld[i] == null) continue;
            this._vld[i].setOption(this._option);
        }
    }

    private void logError(int code, Object msg) {
        if (msg instanceof String) {
            LogTrace.log("modul " + this.DECLARATION_name.toUpperCase() + "Validator; eroare=" + Integer.toString(code) + ": " + msg, 2);
        } else {
            Throwable ex = (Throwable)msg;
            StackTraceElement[] stack = ex.getStackTrace();
            LogTrace.log("modul " + this.DECLARATION_name.toUpperCase() + "Validator; eroare=" + Integer.toString(code) + ": " + ex.toString(), 2);
            for (StackTraceElement el : stack) {
                LogTrace.log(el.toString(), 3);
            }
        }
    }
}

