/*
 * Decompiled with CFR 0.152.
 */
package validator;

import dec.Info;
import dec.LogTrace;
import dec.Options;
import dec.Params;
import dec.Validation;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import validator.DECConnection;

public class Validator {
    static DECConnection _con = null;
    Info _info = null;
    private static Map<String, Validation> _validators = new HashMap<String, Validation>();
    private static Validation _crtValidation = null;
    private static String _rootPath = null;
    private static String _libPath = null;

    public Validator() {
        Validator.findPaths(0);
    }

    private int prepareDoc(String decName) {
        try {
            _crtValidation = _validators.get(decName);
            if (_crtValidation != null) {
                return 1;
            }
            if (_libPath == null || _rootPath == null) {
                Validator.logError(-9, "cale lib nedeterminata");
                return -9;
            }
            String jarName = _libPath + decName + "Validator.jar";
            File jar = new File(jarName);
            if (!jar.exists() && !(jar = new File(jarName = _rootPath + decName + "Validator.jar")).exists()) {
                Validator.logError(-8, "nu gasesc " + jarName);
                return -8;
            }
            URLClassLoader clsLoader = new URLClassLoader(new URL[]{jar.toURI().toURL()});
            String clsName = decName.toLowerCase() + "validator.Validator";
            _crtValidation = (Validation)Class.forName(clsName, true, clsLoader).newInstance();
            if (_con != null) {
                _crtValidation.setDbConnection(_con.getConnection());
            }
            _validators.put(decName, _crtValidation);
        }
        catch (ClassNotFoundException ex) {
            Validator.logError(-6, ex);
            return -6;
        }
        catch (InstantiationException ex) {
            Validator.logError(-7, ex);
            return -7;
        }
        catch (IllegalAccessException ex) {
            Validator.logError(-7, ex);
            return -7;
        }
        catch (Throwable ex) {
            Validator.logError(-5, ex);
            return -5;
        }
        return 0;
    }

    public int parseDocument(String decName, String xmlFile, String errFile, int an, int luna, String tipPerioada) {
        int ret = 0;
        try {
            int crt = this.prepareDoc(decName);
            if (crt < 0) {
                return crt;
            }
            ret = _crtValidation.parseDocument(xmlFile, errFile, an, luna, tipPerioada);
            this._info = _crtValidation.getInfo();
        }
        catch (Throwable ex) {
            Validator.logError(-5, ex);
            return -5;
        }
        return ret;
    }

    public int parseDocument(String decName, String xmlFile, String errFile, String version) {
        int ret = 0;
        try {
            int crt = this.prepareDoc(decName);
            if (crt < 0) {
                return crt;
            }
            ret = _crtValidation.parseDocument(xmlFile, errFile, version);
            this._info = _crtValidation.getInfo();
        }
        catch (Throwable ex) {
            Validator.logError(-5, ex);
            return -5;
        }
        return ret;
    }

    public int parseDocument(String decName, String xmlFile, String errFile) {
        int ret = 0;
        try {
            int crt = this.prepareDoc(decName);
            if (crt < 0) {
                return crt;
            }
            ret = _crtValidation.parseDocument(xmlFile, errFile);
            this._info = _crtValidation.getInfo();
        }
        catch (Throwable ex) {
            Validator.logError(-5, ex);
            return -5;
        }
        return ret;
    }

    public Info getInfo() {
        return this._info;
    }

    public Options[] getOptions(String decName) {
        try {
            if (this.prepareDoc(decName) < 0) {
                return null;
            }
            return _crtValidation.getOptions();
        }
        catch (Throwable ex) {
            Validator.logError(0, ex);
            return null;
        }
    }

    public void useOptions(String decName, long option) {
        try {
            if (this.prepareDoc(decName) >= 0) {
                _crtValidation.useOptions(option);
            }
        }
        catch (Throwable ex) {
            Validator.logError(0, ex);
        }
    }

    public String getLastVersion(String decName) {
        try {
            if (this.prepareDoc(decName) < 0) {
                return null;
            }
            return _crtValidation.getLastVersion();
        }
        catch (Throwable ex) {
            Validator.logError(0, ex);
            return null;
        }
    }

    private static void findPaths(int level) {
        int len = 0;
        try {
            String par;
            URL url = Validator.class.getProtectionDomain().getCodeSource().getLocation();
            try {
                par = level == 0 ? url.toURI().getPath() : url.getPath();
            }
            catch (Throwable ex) {
                par = url.getPath();
            }
            len = par.indexOf("Validator.jar");
            if (len < 0) {
                File lib = new File("lib");
                if (lib.isDirectory()) {
                    _rootPath = _libPath = Validator.padPath(lib.getCanonicalPath());
                    return;
                }
            } else {
                _rootPath = Validator.padPath(par.substring(0, len));
                if (new File(_rootPath).isDirectory()) {
                    _libPath = Validator.padPath(_rootPath + "lib");
                    if (new File(_libPath).isDirectory()) {
                        return;
                    }
                    _libPath = _rootPath;
                    return;
                }
                if (level == 0) {
                    Validator.findPaths(level + 1);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _rootPath = null;
        _libPath = null;
    }

    private static String padPath(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            return path + File.separator;
        }
        return path;
    }

    public static void main(String[] args) {
        String err = null;
        String message = null;
        String tipPerioada = null;
        String decName = null;
        int year = 0;
        int month = 0;
        int mode = 0;
        Date sd = new Date();
        Validator superValidator = null;
        int ret = 0;
        String errFile = "";
        String connection = null;
        String xmlPath = null;
        String logFile = null;
        String traceFile = null;
        int minTraceLevel = 0;
        boolean flush = false;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormat.setLenient(false);
        int agentId = 0;
        int continuumPrim = -1;
        int continuumUltim = -1;
        int continuumAstept = 500;
        int continuumCicli = 120;
        int cntCicli = 0;
        int cntLast = 0;
        int crtDay = new Date().getDay();
        String[] parts = null;
        if (args.length == 2) {
            try {
                agentId = Integer.parseInt(args[1]);
            }
            catch (Throwable e) {
                System.out.println("parametru agent_id eronat");
                return;
            }
            Params.init((String)args[0]);
            try {
                connection = Params.getProperty((String)"continuum");
                if (connection != null) {
                    try {
                        parts = connection.split(":");
                        continuumPrim = Integer.parseInt(parts[0]);
                        if (parts.length <= 1) {
                            continuumUltim = continuumPrim;
                            continuumAstept = 500;
                            continuumCicli = 60000 / continuumAstept;
                        } else {
                            continuumUltim = Integer.parseInt(parts[1]);
                            if (parts.length <= 2) {
                                continuumAstept = 500;
                                continuumCicli = 60000 / continuumAstept;
                            } else {
                                continuumAstept = Integer.parseInt(parts[2]);
                                continuumCicli = parts.length <= 3 ? 60000 / continuumAstept : Integer.parseInt(parts[3]);
                            }
                        }
                    }
                    catch (Throwable ex) {
                        continuumPrim = -1;
                        continuumUltim = -1;
                    }
                }
                xmlPath = Params.getPath((String)"xmlPath");
                logFile = Params.getPath((String)"logFile");
                traceFile = Params.getProperty((String)"flush");
                flush = traceFile != null && traceFile.equals("Y");
                traceFile = Params.getProperty((String)"minTraceLevel");
                if (traceFile != null && !traceFile.equals("")) {
                    try {
                        minTraceLevel = Integer.parseInt(traceFile);
                    }
                    catch (Throwable ex) {
                        minTraceLevel = 0;
                    }
                }
                traceFile = Params.getPath((String)"traceFile");
                if (xmlPath == null || logFile == null) {
                    System.out.println("fisier configurare incorect: lipsa xmlPath sau logFile");
                    return;
                }
            }
            catch (Throwable e) {
                System.out.println("fisier configurare lipsa sau incorect");
                return;
            }
            xmlPath = Validator.padPath(xmlPath);
            boolean val = false;
            String nl = System.getProperty("line.separator");
            LogTrace.init((String)logFile, (String)traceFile, (int)agentId, (int)minTraceLevel, (boolean)flush);
            message = LogTrace.log((String)"Inceput sesiune", (int)0);
            if (message != null) {
                LogTrace.close();
                System.out.println("nu pot deschide fisier log: " + message);
                return;
            }
            _con = new DECConnection();
            err = _con.connectDB("connection", agentId);
            if (err != null) {
                message = LogTrace.log((String)("eroare conectare: " + err), (int)-1);
                if (message != null) {
                    System.out.println("eroare scriere fisier log" + message);
                }
                LogTrace.close();
                return;
            }
            superValidator = new Validator();
            cntCicli = continuumCicli;
            cntLast = 0;
            int cnt = 0;
            while (true) {
                Object[] values = _con.getDeclaratie(agentId);
                err = (String)values[0];
                mode = (Integer)values[1];
                if (mode < 0) {
                    Date ed;
                    if (mode == -1 && agentId >= continuumPrim && agentId <= continuumUltim) {
                        try {
                            Thread.sleep(continuumAstept);
                            if (--cntCicli <= 0) {
                                ed = new Date();
                                if (cnt != cntLast) {
                                    LogTrace.log((String)("S-au procesat " + cnt + " declaratii   (" + dateFormat.format(ed) + ")"), (int)1);
                                } else {
                                    LogTrace.log((String)("S-au procesat " + cnt + " declaratii"), (int)3);
                                }
                                LogTrace.flushLog();
                                cntCicli = continuumCicli;
                                cntLast = cnt;
                                if (ed.getDay() != crtDay) {
                                    mode = -2;
                                    err = "sfarsit de zi - deschide fisier de log nou";
                                }
                            }
                        }
                        catch (Throwable ex) {
                            // empty catch block
                        }
                        if (mode == -1) continue;
                    }
                    if (mode != -4) {
                        ed = new Date();
                        LogTrace.log((String)("Sfarsit sesiune (durata=" + Long.toString(ed.getTime() - sd.getTime()) + " ms): " + err), (int)0);
                        LogTrace.log((String)("S-au procesat " + cnt + " declaratii"), (int)(cnt != 0 ? 1 : 3));
                    } else {
                        LogTrace.log((String)("eroare: " + err), (int)2);
                    }
                    if (mode < 0 && mode != -4) {
                        break;
                    }
                } else {
                    errFile = xmlPath + err;
                    superValidator.useOptions((String)values[2], mode);
                    ret = superValidator.parseDocument((String)values[2], errFile, errFile + ".err", (Integer)values[3], (Integer)values[4], (String)values[5]);
                }
                ++cnt;
            }
            _con.close();
            LogTrace.close();
            return;
        }
        if (args.length != 6) {
            System.out.println("numar incorect de parametri");
            return;
        }
        decName = args[1];
        int cnt = Integer.parseInt(args[5]);
        String version = args[4];
        if (version.equals("X")) {
            mode = 0;
        } else if (version.startsWith("J")) {
            mode = 1;
        } else {
            try {
                String[] constit = version.split("-");
                if (constit.length != 2) {
                    System.out.println("parametru an-luna/versiune incorect");
                    return;
                }
                year = Integer.parseInt(constit[0]);
                tipPerioada = constit[1].substring(0, 1);
                month = Integer.parseInt(constit[1].substring(1));
            }
            catch (Throwable er) {
                System.out.println("parametru an-luna incorect");
                return;
            }
            mode = 2;
        }
        if (!args[3].equals("0")) {
            errFile = args[3];
        }
        LogTrace.init((String)(args[2] + ".log"), (String)(args[2] + ".trc"), (int)0, (int)100, (boolean)true);
        superValidator = new Validator();
        superValidator.useOptions(decName, 0L);
        block17: for (int i = 0; i < cnt; ++i) {
            switch (mode) {
                case 0: {
                    ret = superValidator.parseDocument(decName, args[2], errFile);
                    continue block17;
                }
                case 1: {
                    ret = superValidator.parseDocument(decName, args[2], errFile, version);
                    continue block17;
                }
                default: {
                    ret = superValidator.parseDocument(decName, args[2], errFile, year, month, tipPerioada);
                }
            }
        }
        LogTrace.close();
        Date ed = new Date();
        System.out.println("tip declaratie = " + args[1]);
        System.out.println("xmlFile = " + args[2]);
        System.out.println("errFile = " + (errFile.equals("") ? args[2] + ".err.txt" : errFile));
        System.out.println("return = " + Integer.toString(ret) + "; durata = " + Long.toString(ed.getTime() - sd.getTime()) + " milisecunde");
    }

    private static void logError(int code, Object msg) {
        if (msg instanceof String) {
            LogTrace.log((String)("modul Validator; eroare=" + Integer.toString(code) + ": " + msg), (int)2);
        } else {
            Throwable ex = (Throwable)msg;
            StackTraceElement[] stack = ex.getStackTrace();
            LogTrace.log((String)("modul Validator; eroare=" + Integer.toString(code) + ": " + ex.toString()), (int)2);
            for (StackTraceElement el : stack) {
                LogTrace.log((String)el.toString(), (int)3);
            }
        }
    }
}

