/*
 * Decompiled with CFR 0.152.
 */
package general;

import dec.Info;
import dec.LogTrace;
import dec.Options;
import general.CertificateChooserImpl;
import java.io.File;
import pdf.PdfSuperCreator;
import pdf.Sign;
import pdf.VPdf;
import ui.CertificateChooser;
import validator.Validator;

public class Integrator {
    public static String _newLine = System.getProperty("line.separator");
    public static final long MAX_ZIP_LENGTH = 10000000L;
    private Validator _validator = null;
    private PdfSuperCreator _pdf = null;
    private String _declType = null;
    private Info _validationInfo = null;
    private String _configPath = null;
    private String _errMessage = null;
    private StringBuilder _finalMessage = new StringBuilder(2048);
    private Sign _sign = null;
    private CertificateChooser _chooser = null;
    private int _chooserIndex = 0;
    private int _cnt = 0;
    private VPdf _vPdf = null;
    private int _inputType = 0;
    private String _extractedXmlFile = null;
    private String _extractedZipFile = null;

    public Integrator() {
        this._validator = new Validator();
        this._pdf = new PdfSuperCreator();
        this._vPdf = new VPdf();
    }

    public void releaseToken() {
        if (this._sign != null) {
            this._sign.releaseToken();
        }
    }

    public Validator getValidator() {
        return this._validator;
    }

    public PdfSuperCreator getPdfSuperCreator() {
        return this._pdf;
    }

    public String getLastVersion() {
        return this._validator.getLastVersion(this._declType);
    }

    public String getPdfLastVersion() {
        return this._pdf.getLastVersion(this._declType);
    }

    public int getPdfZipOption() {
        return this._pdf.getZipOption(this._declType);
    }

    public Options[] getOptions() {
        return this._validator.getOptions(this._declType);
    }

    public String getFinalMessage() {
        return this._finalMessage.toString();
    }

    public String getDeclType() {
        return this._declType;
    }

    public void setDeclType(String _declType) {
        this._declType = _declType;
    }

    public void useOptions(long option) {
        this._validator.useOptions(this._declType, option);
    }

    public int parseDocument(String xmlFile, String errFile) {
        int ret = this.parseDocumentIntern(xmlFile, errFile);
        if (this._inputType != 0 && this._extractedXmlFile != null) {
            new File(this._extractedXmlFile).delete();
            this._extractedXmlFile = null;
        }
        return ret;
    }

    private int verificarePdf(String pdfFile) {
        int ret = 0;
        int general = 0;
        int returns = 0;
        ret = this._vPdf.citirePdf(new File(pdfFile));
        if (ret != 0) {
            this._finalMessage.append("Eroare structura PDF").append(_newLine);
            general = -1;
        }
        if ((ret = this._vPdf.check_Attach(pdfFile)) != 0) {
            this._finalMessage.append("Eroare atasament PDF: ").append(this._vPdf.getRetAtach()).append(_newLine);
            general = -1;
        }
        if (ret < 0) {
            returns = -1;
        }
        if ((ret = this._vPdf.verifySignature(pdfFile)) == -1) {
            this._finalMessage.append("Eroare semnatura PDF: ").append(this._vPdf.getRetSignature()).append(_newLine);
            general = -1;
        }
        if (ret == 1) {
            this._finalMessage.append("Atentionare semnatura PDF: ").append(this._vPdf.getRetSignature()).append(". ").append("Documentul nu poate fi transmis prin internet").append(_newLine);
        }
        if (general >= 0) {
            this._finalMessage.append("Validare fara erori fisier PDF ").append(_newLine);
        }
        return returns;
    }

    private int parseDocumentIntern(String xmlFile, String errFile) {
        int ret = 0;
        int retValidare = -2;
        String raspuns = null;
        ++this._cnt;
        this._finalMessage.setLength(0);
        this._finalMessage.append(this._cnt).append(".").append(_newLine);
        if (!xmlFile.toLowerCase().endsWith(".pdf")) {
            this._inputType = 0;
            return this.parseDocumentXML(xmlFile, errFile);
        }
        this._inputType = 1;
        this._extractedXmlFile = null;
        retValidare = -2;
        this._finalMessage.append("     a. Verificare PDF: ").append(xmlFile).append(_newLine);
        ret = this.verificarePdf(xmlFile);
        if (ret >= 0) {
            this._extractedXmlFile = xmlFile + ".dukintegrator.xml";
            raspuns = VPdf.extractFile(xmlFile, "xml", this._extractedXmlFile);
            if (raspuns == null) {
                this._finalMessage.append("     b. Validare XML:").append(_newLine);
                if (errFile == null || errFile.equals("") || errFile.equals("$")) {
                    errFile = xmlFile + ".err.txt";
                }
                retValidare = this.parseDocumentXML(this._extractedXmlFile, errFile);
            } else {
                this._extractedXmlFile = null;
                this._finalMessage.append(raspuns).append(_newLine);
            }
        }
        if (retValidare >= 0) {
            this._finalMessage.append("     c. Verificare PDF vs. XML:").append(_newLine);
            StringBuilder s = new StringBuilder();
            if (!this._validationInfo._an.equals(this._vPdf.getAn_r())) {
                s.append("an");
            }
            if (!this._validationInfo._luna.equals(this._vPdf.getLuna_r())) {
                if (s.length() > 0) {
                    s.append(", ");
                }
                s.append("luna");
            }
            if (!this._validationInfo._cif.equals(this._vPdf.getCif())) {
                if (s.length() > 0) {
                    s.append(", ");
                }
                s.append("CUI");
            }
            if (!this._validationInfo._sumaControl.equals(this._vPdf.getTotalPlata_A())) {
                if (s.length() > 0) {
                    s.append(", ");
                }
                s.append("sumaControl");
            }
            if (this._validationInfo._rec != null && !this._validationInfo._rec.equals(this._vPdf.getD_rec().equals(" ") ? "0" : (this._vPdf.getD_rec().equals("X") ? "1" : this._vPdf.getD_rec()))) {
                if (s.length() > 0) {
                    s.append(", ");
                }
                s.append("tipDeclaratie");
            }
            if (s.length() > 0) {
                this._finalMessage.append("Erori verificare valori PDF cu valori XML: ").append("Exista diferente la urmatoarele campuri :").append(s.toString()).append(_newLine);
            }
            if (!this._vPdf.getUniversalCode().equals(this._declType)) {
                this._finalMessage.append("Tipul declaratiei (" + this._declType + ") nu corespunde cu cel din PDF (" + this._vPdf.getUniversalCode() + ")" + _newLine);
            } else if (s.length() == 0) {
                this._finalMessage.append("Valorile metadatelor din PDF corespund cu valorile din XML").append(_newLine);
            }
        }
        return retValidare;
    }

    private int parseDocumentXML(String xmlFile, String errFile) {
        try {
            if (errFile == null || errFile.equals("") || errFile.equals("$")) {
                errFile = xmlFile + ".err.txt";
            }
            LogTrace.init((String)(xmlFile + ".log"), (String)(xmlFile + ".trc"), (int)0, (int)100, (boolean)true);
            int returns = this._validator.parseDocument(this._declType, xmlFile, errFile);
            LogTrace.close();
            if (returns < 0) {
                if (returns > -4) {
                    this._finalMessage.append("Erori la validare fisier: ").append(xmlFile).append(_newLine);
                    this._finalMessage.append("       Erorile au fost scrise in fisierul: ").append(errFile).append(_newLine);
                } else if (returns == -4) {
                    this._finalMessage.append("Perioada raportare eronata: ").append(this._declType).append(_newLine);
                } else if (returns == -8) {
                    this._finalMessage.append("Tip declaratie necunoscut: ").append(this._declType).append(_newLine);
                } else {
                    this._finalMessage.append("Erori la validare fisier; cod eroare=").append(Integer.toString(returns)).append(_newLine);
                }
            } else if (returns > 0) {
                this._finalMessage.append("Atentionari la validare fisier: ").append(xmlFile).append(_newLine);
                this._finalMessage.append("       Atentionarile au fost scrise in fisierul: ").append(errFile).append(_newLine);
            } else {
                this._finalMessage.append("Validare fara erori fisier: ").append(xmlFile).append(_newLine);
            }
            this._validationInfo = returns >= 0 ? this._validator.getInfo() : null;
            return returns;
        }
        catch (Throwable e) {
            return -9;
        }
    }

    private void errPdf(String err) {
        this._finalMessage.append("Eroare creare PDF!").append(_newLine);
        this._finalMessage.append("       ").append(err).append(_newLine);
    }

    public int pdfCreation(String xmlFile, String errFile, String zipFile, String pdfFile) {
        int ret = this.pdfCreationIntern(xmlFile, errFile, zipFile, pdfFile);
        if (this._inputType != 0) {
            if (this._extractedXmlFile != null) {
                new File(this._extractedXmlFile).delete();
                this._extractedXmlFile = null;
            }
            if (this._extractedZipFile != null) {
                new File(this._extractedZipFile).delete();
                this._extractedZipFile = null;
            }
        }
        return ret;
    }

    private int pdfCreationIntern(String xmlFile, String errFile, String zipFile, String pdfFile) {
        int ret = 0;
        String rez = null;
        int zipOption = -2;
        CertificateChooser ch = this._chooser;
        this._extractedZipFile = null;
        ret = this.parseDocumentIntern(xmlFile, errFile);
        if (ret < 0) {
            return ret;
        }
        zipOption = this._pdf.getZipOption(this._declType, this._validationInfo);
        if (ch == null) {
            ch = new CertificateChooserImpl(this._chooserIndex);
        }
        if (pdfFile == null || pdfFile.equals("") || pdfFile.equals("$")) {
            pdfFile = this._inputType == 0 ? (xmlFile.toLowerCase().endsWith(".xml") ? xmlFile.substring(0, xmlFile.length() - 4) + ".pdf" : xmlFile + ".pdf") : xmlFile + ".dukintegrator.pdf";
        }
        if (zipFile != null && !zipFile.equals("") && !zipFile.equals("$") && zipOption == -1) {
            this.errPdf("fisier zip specificat dar nepermis in acest document");
            return -100;
        }
        if ((zipFile == null || zipFile.equals("") || zipFile.equals("$")) && this._inputType != 0 && zipOption >= 0) {
            this._extractedZipFile = xmlFile + ".dukintegrator.zip";
            rez = VPdf.extractFile(xmlFile, "zip", this._extractedZipFile);
            if (rez == null) {
                zipFile = this._extractedZipFile;
                this._finalMessage.append("Se va folosi fisierul ZIP atasat").append(_newLine);
            } else {
                this._extractedZipFile = null;
                this._finalMessage.append("Nu exista fisier ZIP atasat").append(_newLine);
            }
        }
        if (zipFile == null) {
            zipFile = ch.chooseZipFile(xmlFile, zipOption);
        } else if (zipFile.equals("$")) {
            zipFile = xmlFile.toLowerCase().endsWith(".xml") ? xmlFile.substring(0, xmlFile.length() - 4) + ".zip" : xmlFile + ".zip";
            if (!new File(zipFile).exists()) {
                zipFile = null;
            }
        } else if (zipFile.equals("")) {
            if (zipOption > 0) {
                this.errPdf("zip obligatoriu dar nespecificat");
                return -100;
            }
        } else if (!new File(zipFile).exists()) {
            zipFile = null;
        }
        if (zipFile == null) {
            this.errPdf("fisier zip negasit");
            return -100;
        }
        if (!zipFile.equals("") && new File(zipFile).length() > 10000000L) {
            this.errPdf("fisier ZIP mai lung de " + Long.toString(10000000L) + " bytes");
            return -100;
        }
        String xmlFileFinal = xmlFile;
        if (this._inputType != 0) {
            xmlFileFinal = this._extractedXmlFile;
        }
        String zipFileFinal = zipFile;
        File file = null;
        File fileSou = null;
        if (!xmlFileFinal.toLowerCase().endsWith(".xml")) {
            file = new File(xmlFileFinal = xmlFileFinal + "_redenumit.xml");
            if (file.exists()) {
                this.errPdf("folositi un fisier cu extensia .xml");
                return -100;
            }
            fileSou = new File(xmlFile);
            if (!fileSou.renameTo(file)) {
                this.errPdf("esec redenumire fisier; folositi un fisier cu extensia .xml");
                return -100;
            }
        }
        if (zipFileFinal != null && !zipFileFinal.equals("") && !zipFileFinal.toLowerCase().endsWith(".zip")) {
            file = new File(zipFileFinal = zipFileFinal + "_redenumit.zip");
            if (file.exists()) {
                this.errPdf("folositi un fisier cu extensia .zip");
                return -100;
            }
            fileSou = new File(zipFile);
            if (!fileSou.renameTo(file)) {
                this.errPdf("esec redenumire fisier; folositi un fisier cu extensia .zip");
                return -100;
            }
        }
        rez = this._pdf.createPdf(this._declType, this._validationInfo, pdfFile, xmlFileFinal, zipFileFinal);
        xmlFileFinal = !xmlFile.equals(xmlFileFinal) && this._inputType == 0 ? (!(fileSou = new File(xmlFileFinal)).renameTo(file = new File(xmlFile)) ? "fisierul " + xmlFile + " a fost redenumit " + xmlFileFinal + "; nu am reusit redenumirea inversa" : null) : null;
        zipFileFinal = !zipFile.equals(zipFileFinal) ? (!(fileSou = new File(zipFileFinal)).renameTo(file = new File(zipFile)) ? "fisierul " + zipFile + " a fost redenumit " + zipFileFinal + "; nu am reusit redenumirea inversa" : null) : null;
        if (rez != null && !rez.equals("")) {
            this.errPdf(rez);
            if (xmlFileFinal != null) {
                this._finalMessage.append("       ").append(xmlFileFinal).append(_newLine);
            }
            if (zipFileFinal != null) {
                this._finalMessage.append("       ").append(zipFileFinal).append(_newLine);
            }
            return -100;
        }
        rez = "";
        if (zipOption >= 0) {
            rez = !zipFile.equals("") ? " (cu" : " (fara";
            rez = rez + " fisier zip atasat)";
        }
        this._finalMessage.append("Fisierul PDF a fost creat cu succes" + rez + ":").append(_newLine);
        this._finalMessage.append("       ").append(pdfFile).append(_newLine);
        if (xmlFileFinal != null) {
            this._finalMessage.append("       ").append(xmlFileFinal).append(_newLine);
        }
        if (zipFileFinal != null) {
            this._finalMessage.append("       ").append(zipFileFinal).append(_newLine);
        }
        return 0;
    }

    public void setChooser(CertificateChooser _chooser) {
        this._chooser = _chooser;
    }

    public void setChooserIndex(int _chooserIndex) {
        this._chooserIndex = _chooserIndex;
    }

    public String getConfigPath() {
        return this._configPath;
    }

    public void setConfigPath(String _configPath) {
        this._configPath = _configPath;
    }

    public void setNoCertificate() {
        if (this._sign != null) {
            this._sign.setNoCertificate();
        }
    }

    public int signPdf(String xmlFile, String errFile, String zipFile, String pdfFile, String pin, String smartCard) {
        String ret = null;
        String pdfTemp = xmlFile + ".pdf";
        CertificateChooser ch = this._chooser;
        int rez = 0;
        if (this._sign == null) {
            this._sign = new Sign();
        }
        if ((rez = this.pdfCreation(xmlFile, errFile, zipFile, pdfTemp)) < 0) {
            return rez;
        }
        if (this._chooser == null) {
            ch = new CertificateChooserImpl(this._chooserIndex);
        }
        if (pdfFile == null || pdfFile.equals("") || pdfFile.equals("$")) {
            pdfFile = xmlFile.toLowerCase().endsWith(".xml") ? xmlFile.substring(0, xmlFile.length() - 4) + "-semnat.pdf" : xmlFile + "-semnat.pdf";
        }
        ret = this._sign.signPdf(pdfTemp, pdfFile, pin, Integrator.padPath(this._configPath) + smartCard + ".cfg", ch);
        File file = new File(pdfTemp);
        file.delete();
        if (ret != null && !ret.equals("")) {
            this._finalMessage.append("Eroare semnare PDF!").append(_newLine);
            this._finalMessage.append("       ").append(ret).append(_newLine);
            return -200;
        }
        this._finalMessage.append("Fisierul PDF a fost semnat cu succes:").append(_newLine);
        this._finalMessage.append("       ").append(pdfFile).append(_newLine);
        return 0;
    }

    private static String padPath(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            return path + File.separator;
        }
        return path;
    }

    public static String adjustString(String par) {
        return par == null ? "" : par;
    }
}

