/*
 * Decompiled with CFR 0.152.
 */
package pdf;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPKCS7;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.XfaForm;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Document;

public class VPdf {
    private static String _newLine = System.getProperty("line.separator");
    private String cif = "";
    private String an_r = "";
    private String luna_r = "";
    private String d_rec = "";
    private String totalPlata_A = "";
    private String universalCode = "";
    private String retSignature = "";
    private String retAtach = "";

    public String getAn_r() {
        return this.an_r;
    }

    public String getCif() {
        return this.cif;
    }

    public String getD_rec() {
        return this.d_rec;
    }

    public String getLuna_r() {
        return this.luna_r;
    }

    public String getRetAtach() {
        return this.retAtach;
    }

    public String getTotalPlata_A() {
        return this.totalPlata_A;
    }

    public String getUniversalCode() {
        return this.universalCode;
    }

    public String getRetSignature() {
        return this.retSignature;
    }

    public int citirePdf(File pdf) {
        int rez = 0;
        PdfReader reader = null;
        try {
            reader = new PdfReader(pdf.getPath());
            AcroFields form = reader.getAcroFields();
            this.cif = VPdf.adjustString(form.getField("cif"));
            this.an_r = VPdf.adjustString(form.getField("an_r"));
            this.luna_r = VPdf.adjustString(form.getField("luna_r"));
            this.d_rec = VPdf.adjustString(form.getField("d_rec"));
            this.totalPlata_A = VPdf.adjustString(form.getField("totalPlata_A"));
            this.universalCode = VPdf.adjustString(form.getField("universalCode"));
            if (this.universalCode.equals("")) {
                rez = this.citirePdfXfa(form);
            }
            this.universalCode = this.universalCode.substring(0, Math.max(this.universalCode.indexOf("_"), Math.min(4, this.universalCode.length())));
        }
        catch (Throwable e) {
            return -1;
        }
        return rez;
    }

    public int citirePdfXfa(AcroFields form) {
        block5: {
            try {
                XfaForm xfa = form.getXfa();
                Document doc = xfa.getDomDocument();
                if (doc != null) {
                    this.cif = VPdf.adjustString(doc.getElementsByTagName("cif").item(0).getFirstChild().getNodeValue());
                    this.an_r = VPdf.adjustString(doc.getElementsByTagName("an_r").item(0).getFirstChild().getNodeValue());
                    this.luna_r = VPdf.adjustString(doc.getElementsByTagName("luna_r").item(0).getFirstChild().getNodeValue());
                    this.d_rec = VPdf.adjustString(doc.getElementsByTagName("d_rec").item(0).getFirstChild().getNodeValue());
                    this.totalPlata_A = VPdf.adjustString(doc.getElementsByTagName("totalPlata_A").item(0).getFirstChild().getNodeValue());
                    try {
                        this.universalCode = VPdf.adjustString(doc.getElementsByTagName("universalCode").item(0).getFirstChild().getNodeValue());
                    }
                    catch (Throwable e) {}
                    break block5;
                }
                return -1;
            }
            catch (Throwable e) {
                return -1;
            }
        }
        return 0;
    }

    public int copyFile(File in, File out) {
        try {
            FileInputStream pdf_contribuabil = new FileInputStream(in);
            FileOutputStream pdf_copiat = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = pdf_contribuabil.read(buf)) != -1) {
                pdf_copiat.write(buf, 0, i);
            }
            pdf_contribuabil.close();
            pdf_copiat.close();
        }
        catch (Throwable ex) {
            return -1;
        }
        return 0;
    }

    public int check_Attach(String pdf) {
        this.retAtach = "";
        try {
            PdfReader reader = new PdfReader(pdf);
            PdfDictionary root = reader.getCatalog();
            PdfDictionary documentnames = root.getAsDict(PdfName.NAMES);
            PdfDictionary embeddedfiles = documentnames.getAsDict(PdfName.EMBEDDEDFILES);
            PdfArray filespecs = embeddedfiles.getAsArray(PdfName.NAMES);
            Object fos = null;
            int cntXML = 0;
            int cntZIP = 0;
            int i = 0;
            while (i < filespecs.size()) {
                filespecs.getAsName(i++);
                PdfDictionary filespec = filespecs.getAsDict(i++);
                PdfDictionary refs = filespec.getAsDict(PdfName.EF);
                Set keys = refs.getKeys();
                Iterator iter = keys.iterator();
                String name = "";
                while (iter.hasNext()) {
                    PdfName key1 = (PdfName)iter.next();
                    name = filespec.getAsString(key1).toString().toLowerCase();
                }
                if (name.endsWith(".xml")) {
                    ++cntXML;
                    continue;
                }
                if (!name.endsWith(".zip")) continue;
                ++cntZIP;
            }
            if (cntXML == 0) {
                this.retAtach = "lipsa XML";
                return -1;
            }
            if (cntXML > 1) {
                this.retAtach = "XML multiplu";
                return 1;
            }
            if (cntZIP > 1) {
                this.retAtach = "ZIP multiplu";
                return 1;
            }
            this.retAtach = "Corect";
            return 0;
        }
        catch (Throwable e) {
            this.retAtach = "Lipsa atasamente";
            return -1;
        }
    }

    public static String padPath(String path) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            return path + File.separator;
        }
        return path;
    }

    public static String adjustString(String par) {
        return par == null ? "" : par;
    }

    public static String extractFile(String pdfName, String extensie, String fileName) {
        PdfReader reader = null;
        try {
            extensie = ".".concat(extensie).toLowerCase();
            reader = new PdfReader(pdfName);
            PdfDictionary root = reader.getCatalog();
            PdfDictionary documentnames = root.getAsDict(PdfName.NAMES);
            PdfDictionary embeddedfiles = documentnames.getAsDict(PdfName.EMBEDDEDFILES);
            PdfArray filespecs = embeddedfiles.getAsArray(PdfName.NAMES);
            int i = 0;
            while (i < filespecs.size()) {
                filespecs.getAsString(i++);
                PdfDictionary filespec = filespecs.getAsDict(i++);
                PdfDictionary refs = filespec.getAsDict(PdfName.EF);
                Set keys = refs.getKeys();
                for (PdfName key1 : keys) {
                    String name = filespec.getAsString(key1).toString().toLowerCase();
                    if (!name.endsWith(extensie)) continue;
                    FileOutputStream fos = new FileOutputStream(fileName);
                    PRStream stream = (PRStream)PdfReader.getPdfObject((PdfObject)refs.getAsIndirectObject(key1));
                    fos.write(PdfReader.getStreamBytes((PRStream)stream));
                    fos.flush();
                    fos.close();
                    return null;
                }
            }
        }
        catch (Throwable e) {
            return "eroare extragere fisier" + extensie.toUpperCase() + ": " + e.toString();
        }
        if (!extensie.equals(".zip")) {
            return "lipsa fisier" + extensie.toUpperCase();
        }
        return "fara";
    }

    public int verifySignature(String fileName) {
        int returns = 0;
        this.retSignature = "";
        try {
            KeyStore kall = PdfPKCS7.loadCacertsKeyStore();
            PdfReader reader = new PdfReader(fileName);
            AcroFields af = reader.getAcroFields();
            ArrayList names = af.getSignatureNames();
            if (names.isEmpty()) {
                this.retSignature = "Pdf-ul nu este semnat";
                returns = 1;
            }
            for (int k = 0; k < names.size(); ++k) {
                String name = (String)names.get(k);
                if (!af.signatureCoversWholeDocument(name)) {
                    if (this.retSignature.length() > 0) {
                        this.retSignature = this.retSignature + _newLine;
                    }
                    this.retSignature = this.retSignature + " Semnatura " + name + " nu acopera tot documentul";
                    returns = -1;
                }
                PdfPKCS7 pk = af.verifySignature(name);
                Calendar cal = pk.getSignDate();
                Certificate[] pkc = pk.getCertificates();
                if (pk.verify()) continue;
                if (this.retSignature.length() > 0) {
                    this.retSignature = this.retSignature + _newLine;
                }
                this.retSignature = this.retSignature + " Document modificat dupa semnare";
                returns = -1;
            }
        }
        catch (Throwable e) {
            this.retSignature = this.retSignature + " Eroare verificare semnatura: " + e.toString();
            return -1;
        }
        return returns;
    }
}

