/*
 * Decompiled with CFR 0.152.
 */
package pdf;

import dec.Info;
import dec.LogTrace;
import java.util.Arrays;
import pdf.Pdf;
import pdf.PdfCreation;

public abstract class PdfCreatorRoot
implements PdfCreation {
    private String DECLARATION_name = null;
    private String[] _dateVersionTable = null;
    private int[] _an;
    private int[] _luna;
    private String[] _version;
    private int[] _idPdf;
    private Pdf[] _pdf;
    private String _error = null;

    protected PdfCreatorRoot() {
    }

    protected void initialize(String decName, String[] dateVersionTable) {
        this.DECLARATION_name = decName;
        this._dateVersionTable = dateVersionTable;
        int len = this._dateVersionTable.length;
        this._pdf = new Pdf[len];
        for (int i = 0; i < len; ++i) {
            this._pdf[i] = null;
        }
        Arrays.sort(this._dateVersionTable);
        this._an = new int[len];
        this._luna = new int[len];
        this._version = new String[len];
        this._idPdf = new int[len];
        for (int i = 0; i < len; ++i) {
            String[] dateStr;
            this._an[i] = 0;
            this._luna[i] = 0;
            this._version[i] = null;
            this._idPdf[i] = 0;
            String entry = this._dateVersionTable[i];
            String[] str = entry.split(" ");
            if (str.length != 4 || (dateStr = str[0].split("-")).length != 2) continue;
            try {
                this._an[i] = Integer.parseInt(dateStr[0]);
                this._luna[i] = Integer.parseInt(dateStr[1]);
                this._version[i] = str[1];
                this._idPdf[i] = Integer.parseInt(str[2]);
                continue;
            }
            catch (Throwable ex) {
                this._an[i] = 0;
                this._luna[i] = 0;
                this._version[i] = null;
                this._idPdf[i] = 0;
            }
        }
    }

    private Pdf getPdf(Info info) {
        Pdf pdf;
        int luna = 0;
        int an = 0;
        int len = this._dateVersionTable.length;
        try {
            luna = Integer.parseInt(info._luna);
            an = Integer.parseInt(info._an);
        }
        catch (Throwable ex) {
            this._error = "creare PDF: clasa info nu contine an/luna valide";
            this.logError(-3, this._error);
            return null;
        }
        try {
            int crt;
            if (an < this._an[0] || an == this._an[0] && luna < this._luna[0] || an >= 2100 || luna < 1 || luna > 12) {
                this._error = "creare PDF: perioada de raportare eronata";
                this.logError(-4, this._error);
                return null;
            }
            for (crt = 1; crt < len && an >= this._an[crt] && (an != this._an[crt] || luna >= this._luna[crt]); ++crt) {
            }
            if ((pdf = this._pdf[--crt]) == null) {
                String clsName = this.DECLARATION_name + ".Pdf_v" + Integer.toString(this._idPdf[crt]);
                this._pdf[crt] = pdf = (Pdf)Class.forName(clsName, true, this.getClass().getClassLoader()).newInstance();
            }
        }
        catch (Throwable ex) {
            this._error = "creare PDF: " + ex.toString();
            this.logError(-5, ex);
            return null;
        }
        return pdf;
    }

    private void logError(int code, Object msg) {
        if (msg instanceof String) {
            LogTrace.log((String)("modul " + this.DECLARATION_name.toUpperCase() + "Pdf; eroare=" + Integer.toString(code) + ": " + msg), (int)2);
        } else {
            Throwable ex = (Throwable)msg;
            StackTraceElement[] stack = ex.getStackTrace();
            LogTrace.log((String)("modul " + this.DECLARATION_name.toUpperCase() + "Pdf; eroare=" + Integer.toString(code) + ": " + ex.toString()), (int)2);
            for (StackTraceElement el : stack) {
                LogTrace.log((String)el.toString(), (int)3);
            }
        }
    }

    public String createPdf(Info info, String pdfFile, String xmlFile, String attFile) {
        Pdf pdf = this.getPdf(info);
        if (pdf == null) {
            return this._error;
        }
        return pdf.createPdf(info, pdfFile, xmlFile, attFile);
    }

    public String getLastVersion() {
        return this._version[this._version.length - 1];
    }

    public abstract int getZipOption();

    public int getZipOption(Info info) {
        Pdf pdf = this.getPdf(info);
        if (pdf == null) {
            return -2;
        }
        return pdf.getZipOption();
    }
}

